#
# Copyright (c) 2020 Omnissa, LLC. All rights reserved.
# This product is protected by copyright and intellectual property laws in the
# United States and other countries as well as by international treaties.
# -- Omnissa Public
#
# This script implements installation check of features.
#
# The result of the script is:
#    yes - feature is installed
#    no - feature is not installed
#    unknown - can't get installation status for feature
#

import sys

# Optional feature list supported on Linux client
installation_list = {
   "USB": "usbEnable",
   "SmartCard": "smartcardEnable",
   "RTAV": "rtavEnable",
   "CDR": "tsdrEnable",
   "TSMMR": "mmrEnable",
   "PrintRedir": "vmipEnable",
   "ScannerRedirection": "scannerEnable",
   "SerialPortRedirection": "serialportEnable",
   "FIDO2": "fido2Enable"
}

feature = sys.argv[1]

if feature not in installation_list:
    print('unknown')
    sys.exit(1)

# Output installation check result
status = installation_list[feature]
print(status)